<?php
  /**
   * View Item
   *
   * @package Digital Downloads Pro
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: account.php, v2.00 2011-07-10 10:12:05 gewa Exp $
   */
  define("_VALID_PHP", true);
  require_once("init.php");
  
  if (!$user->logged_in)
      redirect_to("index.php");
	  
  $row = $item->getFileToDownload();
?>
<?php include("header.php");?>
<?php if(!$row):?>
      <?php $core->msgInfo('<span>!تـوجــه</span>. فایـل مربوط به محصـول درخواستی شمـا یافت نشـد، لطفـا آدرس وارد شده را مجددا بررسی نمائید و یا به حساب کاربری خود رفته و دوباره سعی نمائیـد',false);?>
<?php else:?>
<?php
  if ($row['expiry'] != '0' && $row['tactive'] == 1) {
      if (substr_count($row['expiry'], 'D') != 0) {
          $expiry = substr($row['expiry'], 1) * $row['count'];
          $expiry_msg = $expiry . ' days';
          
          $current_time = time();
          $expiry_time = $row['file_date'] + ($expiry * 24 * 60 * 60);
          $remaining_time = ceil(($expiry_time - time()) / (24 * 60 * 60));
          $elapsed_time = $current_time - $row['file_date'];
          
          if ($current_time > $expiry_time) {
              $expiry_status = '<div class="msgError"><span>!انقضـاء محصـول</span>. این محصـول تمام شـده و در حال حاضر در دسترس نمی باشـد</div>';
              $expired = true;
          } else 
              $expiry_status = '<div class="msgOk"><span>در دستـرس</span> (' . $remaining_time . ' روز باقی مـانـده )</div>';

          
          $bar_width = round((($elapsed_time / ($expiry * 24 * 60 * 60)) * 100), 0);
		  $tbar = ($bar_width > 100) ? 100 : $bar_width;
          $expiry_bar = '<div style="width:'.$tbar.'%">'.$tbar.'%&nbsp;&nbsp;</div>';
      } else {
          $expiry = $row['expiry'] * $row['count'];
          $expiry_msg = $expiry . ' Downloads';
          
          $remaining_downloads = $expiry - $row['file_downloads'];
          
          if ($row['file_downloads'] >= ($row['expiry'] * $row['count'])) {
              $expiry_status = '<div class="msgError"><span>!انقضـاء محصـول</span>. این محصـول تمام شـده و در حال حاضر در دسترس نمی باشـد</div>';
              $expired = true;
          } else
              $expiry_status = '<div class="msgOk"><span>در دستـرس</span> (' . $remaining_downloads . ' دانلـود باقی مـانـده )</div>';
          
          $bar_width = round(($row['file_downloads'] / ($row['expiry'] * $row['count']) * 100), 0);
          $expiry_bar = '<div style="width:'.$bar_width.'%">'.$bar_width.'%&nbsp;&nbsp;</div>';
      }
  } else {
      if ($row['tactive'] == 1)
          $expiry_status = '<div class="msgOk"><span>در دستـرس</span>. این محصـول برای دانلـود در دستـرس می باشـد</div>';
      else {
          $row['expiry'] = 0;
          $expiry_status = '<div class="msgAlert"><span>تـوجـه</span>. این محصـول در انتظـار تائیـد می باشـد</div>';
      }
  }
?>
<?php $url = ($core->seo) ? $core->site_url . '/view-item/' . intval($row['pid']) . '/' . sanitize($row['slug']) . '.html' : $core->site_url . '/item.php?pid=' . intval($row['pid']);?>

  <h1><span><a href="account.php" class="button-alt-sml">برگشـت به دانلـودهـا</a></span>مــدیــریــت دانـلــودهـای شمـا&nbsp;&nbsp;</h1>
  <p class="info">Here you can download all your purchased products.</p>
  <div style="position:relative"> <span id="loader" style="display:none"></span>
    <div id="msgholder"></div>
  </div>
  <div class="box">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th colspan="2" class="right"><?php echo $row['title'];?></th>
        </tr>
      </thead>
      <tfoot>
        <tr>
          <td colspan="2"><?php if (isset($expired) && $row['pactive'] == 1):?>
            <a href="<?php echo $url;?>" class="button-alt-sml">!خـریـد دوبـاره</a>
            <?php elseif ($row['tactive'] == 1):?>
              <a href="download.php?pid=<?php echo $row['pid'];?>" class="button-sml">دانـلــود</a>
            <?php endif;?></td>
        </tr>
      </tfoot>
      <tbody>
      <tr class="odd">
        <th width="200"><strong>تـاریـخ خـریـد :</strong></th>
        <td><?php echo $row['registered'];?></td>
      </tr>
      <tr>
        <th><strong>تـوضیـح :</strong></th>
        <td><?php echo sanitize($row['description']);?></td>
      </tr>
      <tr class="odd">
        <th><strong>نـام فـایـل :</strong></th>
        <td><?php echo $row['alias'];?></td>
      </tr>
      <tr>
        <th><strong>حـجـم فـایـل :</strong></th>
        <td><?php echo getSize($row['filesize']);?></td>
      </tr>
      <tr class="odd">
        <th><strong>دانلـودهـای فـایـل :</strong></th>
        <td><?php echo $row['file_downloads'];?></td>
      </tr>
      <tr>
        <th><strong>وضعیـت انقضـاء :</strong></th>
        <td><?php if ($row['expiry'] != '0') :?>
          انقضـاء پـس از <?php echo $expiry_msg;?>
          <?php else:?>
          NA
          <?php endif;?></td>
      </tr>
      <tr class="odd">
        <th><strong>دستـرسی :</strong></th>
        <td><?php echo $expiry_status; ?></td>
      </tr>
      <?php if ($row['expiry'] != '0'): ?>
      <tr>
        <td colspan="2"><div class="progress-bar"> <?php echo $expiry_bar;?></div></td>
      </tr>
      <?php endif;?>
      </tbody>
    </table>
  </div>
<?php endif;?>
<?php include("footer.php");?>